#include "stdafx.h"
#include <fstream>
#include "Device.h"

const char *initSaveDir = "Save Directory";

bbSettings_t& bbSettings_t::operator=(const bbSettings_t &other) 
{
	path = other.path;		
	captureTitle = other.captureTitle;
	center = other.center;
	gain = other.gain;
	atten = other.atten;
	captureTrigger = other.captureTrigger;
	extTimebase = other.extTimebase;
	extType = other.extType;
	decimation = other.decimation;
	bandwidth = other.bandwidth;
	capture_len = other.capture_len;
	return *this;
}

bool bbSettings_t::operator==(const bbSettings_t &other) const
{
	if(path != other.path) return false;
	if(captureTitle != other.captureTitle) return false;
	if(center != other.center) return false;
	if(gain != other.gain) return false;
	if(atten != other.atten) return false;
	if(captureTrigger != other.captureTrigger) return false;
	if(extTimebase != other.extTimebase) return false;
	if(extType != other.extType) return false;
	if(decimation != other.decimation) return false;
	if(bandwidth != other.bandwidth) return false;
	if(capture_len != other.capture_len) return false;
	return true;
}

bbDevice::bbDevice() 
{
	open = false;
	id = -1;
	last_status = bbNoError;
}

bbDevice::~bbDevice()
{
	
}

void bbDevice::Open() 
{	
	if(IsOpen()) {
		return;
	}

	bbStatus stat;
	stat = bbOpenDevice(&id);

	if(stat >= bbNoError) {
		open = true;
	}
}

void bbDevice::Close() 
{
	if(!IsOpen()) {
		return;
	}

	bbCloseDevice(id);
	id = -1;
	open = false;
}

void bbDevice::Configure(const bbSettings_t &s)
{
	if(!open) {
		return;
	}

	bbStatus stat;
	int port = 0;
	
	bbAbort(id);
	//bbConfigureIO(id, 0, BB_PORT2_IN_TRIGGER_RISING_EDGE);
	bbConfigureIQ(id, 0x1 << s.decimation, s.bandwidth * 1.0e6);
	bbConfigureCenterSpan(id, s.center * 1.0e6, 1.0e6);
	bbConfigureLevel(id, REF_LEVEL, s.atten);
	bbConfigureGain(id, s.gain);

	if(s.extTimebase) {
		port = BB_PORT1_EXT_REF_IN;

		// AC coupled == 0, no need to do anything
		if(s.extType == bbSettings_t::DC_COUPLED) {
			port |= BB_PORT1_DC_COUPLED;
		}
	}

	bbConfigureIO(id, port, BB_PORT2_IN_TRIGGER_RISING_EDGE);

	//stat = bbInitiate(id, BB_RAW_PIPE, s.bandwidth | BB_TIME_STAMP);
	stat = bbInitiate(id, BB_STREAMING, BB_STREAM_IQ);

	if(stat != bbNoError) {
		MessageBoxA(0, bbGetErrorString(stat), 0, IDOK);
	}
	
	collect_count = (0x1 << s.decimation) / 4;
	if(collect_count <= 0) collect_count = 1;
	if(collect_count > 1) collect_count = 4;
	iq_len = (0x1 << 20) / (0x1 << s.decimation);

	// Corrections, not using currently
	//std::ofstream file("corr.plot");
	int index;
	double start;
	//bbFetchRawCorrections(id, cc, &index, &start);

	//for(int i = 0; i < 2048; i++)
	//	file << i << " " << cc[i] << std::endl;
}

void bbDevice::GetSpectrum(float *buf, int *trigArray) 
{
	for(int i = 0; i < collect_count; i++) {
		last_status = bbFetchRaw(id, buf + i * iq_len, trigArray);
	}
}